/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  SWITCH implementation
 *
 */
#include "stdio.h"
#include "switch.h"
#include "gpio.h"
#include "dm388_McASP.h"
#include "dm388_EVM.h"
#include "platform.h"


/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  SWITCH_init                                                  			*
 *                                                                          *
 *  Initiates the switch module (i.e. keyscan)                           	*
 *                                                                          *
 * ------------------------------------------------------------------------ */

UINT16 switch_init()
{
	WR_MEM_32(DM388_MCASP0_BASE + MCASP_PFUNC_OFFSET,0x00000020);
	/* Reset GPIO Subsystem */
	GPIO1_SYSCONFIG = 0x00000020; /* Software Reset */
	DM388_wait(0x90000);
	GPIO1_SYSCONFIG = 0x100; /* no-idle */
	
	/* Reset GPIO Subsystem */
	GPIO0_SYSCONFIG = 0x00000020; /* Software Reset */
	DM388_wait(0x90000);
	GPIO0_SYSCONFIG = 0x100; /* no-idle */
    return 0;
}	

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  switch_test                                                  			*
 *                                                                          *
 *  Get the current switch pressed  							            *
 *                                                                          *
 * ------------------------------------------------------------------------ */
INT32 switch_test(void *testargs)
{
    platform_write("\n***************************\n\r");
    platform_write(  "         Switch Test       \n\r");
    platform_write(  "***************************\n\r");
    platform_write("\nRunning Switch Position Test\n");
    platform_write("\nPress any  switch on the dm388 board and check if the corresponding switch name is displayed on the console\n");

	switch_init();
	switch_get_press();

	platform_write("\nSwitch Position Test Completed\n");
	platform_write("\nSwitch Test Completed!!\n");
	platform_write("-----------x----------");
	return 0;

}

/* ----------------------------------------------------------------------- *
 *     switch_get_press()                                                  *
 *                                                                         *
 *                                                                         *
 *     Sends the current switch pressed                                    *
 * ----------------------------------------------------------------------- */

void switch_get_press()
{
	key switch_num;
	UINT32 data;
#ifdef DEBUG
	UINT8 loop=TRUE;
	UINT8 val;
while(loop)
#endif
 {
	if((GPIO1_DATAIN & 0x00000400) == 0)
    {
	switch_num=SWITCH_0;
    platform_write("\n switch 5 is pressed ");
    }
	else
	{
		platform_write("\n switch 5 is in off position ");
		DM388_wait(10000);
	}

	//DM388_wait(10000);
	if((GPIO0_DATAIN & 0x00002000) == 1)
	{
	switch_num=SWITCH_1;
	platform_write("\n switch 6 is pressed ");
	}
	else
	{
	platform_write("\n switch 6 is in off position ");
	DM388_wait(10000);
	}
	//DM388_wait(10000);
	if((GPIO0_DATAIN & 0x000001000) == 1)
	{
    switch_num=SWITCH_2;
    platform_write("\n switch 7 is pressed ");
	}
	else
	{
	platform_write("\n switch 7 is in off position ");
	DM388_wait(10000);
	}

	DM388_wait(10000);
	data = RD_MEM_32(DM388_MCASP0_BASE + MCASP_PDSET_OFFSET);
	//data = data & 0x00000020;
	if((data & 0x00000020) == 0)
	{
	switch_num=SWITCH_3;
	platform_write("\n switch 8 is pressed ");
	}
	else
	{
	platform_write("\n switch 8 is in off position ");
	DM388_wait(10000);
	}
#ifdef DEBUG
	platform_write("\n Press X/x for exiting the test ");
	platform_write("\n Press Y/y to continue ");
	platform_read(&val, 1);
	if((val == 'y') || (val == 'Y'))
	{
		platform_write("\n continue\n");
		DM388_wait(10000);
	}
	if((val == 'x') || (val == 'X'))
	{
		loop=FALSE;
		platform_write("\n Exiting from the  Switch Position test\n");
	}
#endif
 }
}



